/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;

public class PropertyValidation
implements PropertyFactory {
    private Vector notifyOnSet;

    public Serializable doValidateApplyAndMap(TransactionController transactionController, String string, Serializable serializable, Dictionary dictionary, boolean bl) throws StandardException {
        Serializable serializable2 = null;
        if (this.notifyOnSet != null) {
            PropertyValidation propertyValidation = this;
            synchronized (propertyValidation) {
                int n = 0;
                while (n < this.notifyOnSet.size()) {
                    PropertySetCallback propertySetCallback = (PropertySetCallback)this.notifyOnSet.elementAt(n);
                    if (propertySetCallback.validate(string, serializable, dictionary) && (bl || !string.startsWith("derby.") || PropertyUtil.whereSet(string, dictionary) != 0)) {
                        Serviceable serviceable = propertySetCallback.apply(string, serializable, dictionary);
                        if (serviceable != null) {
                            ((TransactionManager)transactionController).addPostCommitWork(serviceable);
                        }
                        if (serializable2 == null) {
                            serializable2 = propertySetCallback.map(string, serializable, dictionary);
                        }
                    }
                    ++n;
                }
            }
        }
        return serializable2;
    }

    public Serializable doMap(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        Serializable serializable2 = null;
        if (this.notifyOnSet != null) {
            int n = 0;
            while (n < this.notifyOnSet.size() && serializable2 == null) {
                PropertySetCallback propertySetCallback = (PropertySetCallback)this.notifyOnSet.elementAt(n);
                serializable2 = propertySetCallback.map(string, serializable, dictionary);
                ++n;
            }
        }
        if (serializable2 == null) {
            return serializable;
        }
        return serializable2;
    }

    public void validateSingleProperty(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("logDevice")) {
            throw StandardException.newException("XSRS8.S");
        }
        if (this.notifyOnSet != null) {
            int n = 0;
            while (n < this.notifyOnSet.size()) {
                PropertySetCallback propertySetCallback = (PropertySetCallback)this.notifyOnSet.elementAt(n);
                propertySetCallback.validate(string, serializable, dictionary);
                ++n;
            }
        }
    }

    public synchronized void addPropertySetNotification(PropertySetCallback propertySetCallback) {
        if (this.notifyOnSet == null) {
            this.notifyOnSet = new Vector(1, 1);
        }
        this.notifyOnSet.addElement(propertySetCallback);
    }

    public synchronized void verifyPropertySet(Properties properties, Properties properties2) throws StandardException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties2.getProperty(string) != null) continue;
            String string2 = properties.getProperty(string);
            this.validateSingleProperty(string, (Serializable)((Object)string2), properties);
        }
    }
}

